import os
import json
import argparse
from env_utils import get_buy_info_from_json

def get_buy_info(line):
    '''
    convert single line json into buy info
    '''
    line_json = json.loads(line)
    return get_buy_info_from_json(line_json)

def batch_all_buy(data_dir, input_dir, file_name='webshop.jsonl'):
    dir_path=os.path.join(data_dir, input_dir)
    write_path = os.path.join(dir_path, 'shop_reward.jsonl')
    if os.path.exists(write_path):
        os.remove(write_path)
    with open(os.path.join(dir_path, file_name), "r") as fr:
        lines = fr.readlines()
        count = 0
        for line in lines:
            # print(count)
            count = count + 1
            result = get_buy_info(line=line)
            if result['buy']:
                with open(os.path.join(dir_path, 'shop_reward.jsonl'), "a") as fw:
                    json.dump(result, fw)
                    fw.write('\n')

if __name__ == "__main__":
    
    # test_info = '''
    # {"idx": 314, "history": [{"observation": "WebShop [SEP] Instruction: [SEP] i need some whitening toothpaste, and price lower than 40.00 dollars [SEP] Search", "available_actions": {"has_search_bar": true, "clickables": ["search"]}, "action": "search[whitening toothpaste]", "reward": 0.0, "done": false}, {"observation": "Instruction: [SEP] i need some whitening toothpaste, and price lower than 40.00 dollars [SEP] Back to Search [SEP] Page 1 (Total results: 50) [SEP] Next > [SEP] B09S5ZZ4MC [SEP] Teeth Whitening Toothpaste, 2pcs Whitening Toothpaste Deep Cleaning Toothpaste Oral Protection Fruit Flavor Toothpaste(200ml) [SEP] $35.29 [SEP] B09N9M2MFF [SEP] YEZIJIN White Foam Toothpaste, Deep Cleaning Teeth Whitening Toothpaste Liquid Natural Mouth Wash Water, Repair Toothpaste for Sensitive Teeth, to Reharden and Strengthen Enamel [SEP] $100.0 [SEP] B09N9LBDQF [SEP] YEZIJIN Whitening Foam Toothpaste - Baking Soda Toothpaste,Ultra-fine Mousse Foam Deeply Cleaning Gums,Stain Removal | Easy to Use | Oral Care-Toothpaste Replacement Natural Mouth Wash Water [SEP] $100.0 [SEP] B09T3K16KY [SEP] Whitening Toothpaste, 200ml Natural Toothpaste for Whitening & Oral Care,Travel Friendly, Oral Care-Toothpaste Replacement, Blue Berry Stain Removal Freshen Breath Healthy Teeth [SEP] $12.56 [SEP] B09QKPCC5W [SEP] Whitening Toothpaste, Stain Removal Foam Toothpaste, 200ml Blue Berry Stain Removal Freshen Breath Healthy Teeth Whitening Toothpaste [SEP] $14.62 [SEP] B09QQFCTT9 [SEP] V34 Colour Corrector Gel Teeth Whitening Teeth Brighten Toothpaste, 2PCS Teeth Cleansing Toothpaste Tooth Whitening Enamel Care Toothpaste,Intensive Stain Removal Teeth Whitening Toothpaste (Brighten) [SEP] $13.99 [SEP] B09RPBYZX8 [SEP] V34 Colour Corrector Gel and Enamel Care Toothpaste,2PCS Teeth Whitening Teeth Sensitive Toothpaste, Teeth Cleansing Toothpaste Tooth Whitening,Intensive Stain Removal Teeth Whitening Toothpaste [SEP] $13.99 [SEP] B09RPBYZZS [SEP] Enamel Care Toothpaste and V34 Colour Corrector Gel Set,Teeth Whitening Teeth Sensitive Toothpaste, Teeth Cleansing Toothpaste Tooth Whitening,Intensive Stain Removal Teeth Whitening Toothpaste [SEP] $12.99 [SEP] B09RPHZNC7 [SEP] Enamel Care Toothpaste,2PCS Colour Corrector Gel Teeth Whitening Teeth Sensitive Toothpaste, Teeth Cleansing Toothpaste Tooth Whitening,Intensive Stain Removal Teeth Whitening Toothpaste [SEP] $13.99 [SEP] B09RPQXBDH [SEP] 2PCS V34 Colour Corrector Gel Teeth Whitening Teeth Brighten Toothpaste,Teeth Cleansing Toothpaste Tooth Whitening Enamel Care Toothpaste,Intensive Stain Removal Teeth Whitening Toothpaste [SEP] $13.99", "available_actions": {"has_search_bar": false, "clickables": ["back to search", "next >", "b09s5zz4mc", "b09n9m2mff", "b09n9lbdqf", "b09t3k16ky", "b09qkpcc5w", "b09qqfctt9", "b09rpbyzx8", "b09rpbyzzs", "b09rphznc7", "b09rpqxbdh"]}, "action": "click[b09s5zz4mc]", "reward": 0.0, "done": false}, {"observation": "Instruction: [SEP] i need some whitening toothpaste, and price lower than 40.00 dollars [SEP] Back to Search [SEP] < Prev [SEP] Teeth Whitening Toothpaste, 2pcs Whitening Toothpaste Deep Cleaning Toothpaste Oral Protection Fruit Flavor Toothpaste(200ml) [SEP] Price: $35.29 [SEP] Rating: N.A. [SEP] Description [SEP] Features [SEP] Reviews [SEP] Buy Now", "available_actions": {"has_search_bar": false, "clickables": ["back to search", "< prev", "description", "features", "reviews", "buy now"]}, "action": "click[description]", "reward": 0.0, "done": false}, {"observation": "Instruction: [SEP] i need some whitening toothpaste, and price lower than 40.00 dollars [SEP] Back to Search [SEP] < Prev [SEP] Specification: Item Type: Toothpaste Material: Organic matter Net Content: 2 x 200ml  Package List: 2 x Toothpaste", "available_actions": {"has_search_bar": false, "clickables": ["back to search", "< prev"]}, "action": "click[< prev]", "reward": 0.0, "done": false}, {"observation": "Instruction: [SEP] i need some whitening toothpaste, and price lower than 40.00 dollars [SEP] Back to Search [SEP] < Prev [SEP] Teeth Whitening Toothpaste, 2pcs Whitening Toothpaste Deep Cleaning Toothpaste Oral Protection Fruit Flavor Toothpaste(200ml) [SEP] Price: $35.29 [SEP] Rating: N.A. [SEP] Description [SEP] Features [SEP] Reviews [SEP] Buy Now", "available_actions": {"has_search_bar": false, "clickables": ["back to search", "< prev", "description", "features", "reviews", "buy now"]}, "action": "click[features]", "reward": 0.0, "done": false}, {"observation": "Instruction: [SEP] i need some whitening toothpaste, and price lower than 40.00 dollars [SEP] Back to Search [SEP] < Prev [SEP] UNIQUE DESIGN: This teeth whitening toothpaste has a unique bottle design, which is beautiful and easy to carry. Combat stains on teeth, tongue, cheeks and gums, brush your teeth with toothpaste after meals or after waking up in the morning for fresh breath and a clean oral environment to avoid oral problems. STAIN REMOVAL AND WHITENING: Sensitive Teeth Whitening Toothpaste contains cleansing ingredients that help remove stains and whiten teeth. Whitening Toothpaste helps reduce stains, cleans teeth, leaves teeth healthy and white, freshens breath, creates a healthy oral environment, and goes beyond superficial stain removal to deep whitening. FRESH BREATH: Whitening Natural Toothpaste helps prevent bad breath and helps you avoid some embarrassing situations. Teeth whitening toothpaste with a breakthrough formula that provides multiple benefits, stain removal toothpaste removes and prevents new stains, toothpaste protects a healthier mouth, twice daily for 4 weeks. PRESET DOSAGE: This tooth whitening toothpaste uses a preset release dosage, which is economical and practical. Smiling is show time! Freshen Breath Healthy Teeth Whitening Toothpaste can help you achieve beautiful white teeth, give you a dazzling smile, and make your teeth shine like pearls for a complete whitening experience. CLEAN TEETH: Teeth Whitening Toothpaste can see teeth whitening with continued use, and whitening teeth takes a process. With continued use, this teeth whitening toothpaste will give you fresh breath and clean teeth. The net content of Travel Size Toothpaste is 200ml.", "available_actions": {"has_search_bar": false, "clickables": ["back to search", "< prev"]}, "action": "click[< prev]", "reward": 0.0, "done": false}, {"observation": "Instruction: [SEP] i need some whitening toothpaste, and price lower than 40.00 dollars [SEP] Back to Search [SEP] < Prev [SEP] Teeth Whitening Toothpaste, 2pcs Whitening Toothpaste Deep Cleaning Toothpaste Oral Protection Fruit Flavor Toothpaste(200ml) [SEP] Price: $35.29 [SEP] Rating: N.A. [SEP] Description [SEP] Features [SEP] Reviews [SEP] Buy Now", "available_actions": {"has_search_bar": false, "clickables": ["back to search", "< prev", "description", "features", "reviews", "buy now"]}, "action": "click[reviews]", "reward": 0.0, "done": false}, {"observation": "Instruction: [SEP] i need some whitening toothpaste, and price lower than 40.00 dollars [SEP] Back to Search [SEP] < Prev", "available_actions": {"has_search_bar": false, "clickables": ["back to search", "< prev"]}, "action": "click[< prev]", "reward": 0.0, "done": false}, {"observation": "Instruction: [SEP] i need some whitening toothpaste, and price lower than 40.00 dollars [SEP] Back to Search [SEP] < Prev [SEP] Teeth Whitening Toothpaste, 2pcs Whitening Toothpaste Deep Cleaning Toothpaste Oral Protection Fruit Flavor Toothpaste(200ml) [SEP] Price: $35.29 [SEP] Rating: N.A. [SEP] Description [SEP] Features [SEP] Reviews [SEP] Buy Now", "available_actions": {"has_search_bar": false, "clickables": ["back to search", "< prev", "description", "features", "reviews", "buy now"]}, "action": "click[buy now]", "reward": 1.0, "done": true}], "reward": 1.0}
    # '''
    # print(get_buy_info(test_info))
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument('--data_dir', type=str, default='', required=True, help='')
    parser.add_argument('--input_dir', type=str, default='', required=True, help='')
    args = parser.parse_args()
    input_dir = args.input_dir
    data_dir = args.data_dir
    batch_all_buy(data_dir, input_dir, 'webshop.jsonl')
